/////////////////////////////////////////////////////////////////////////////
// DialogEx.h
/////////////////////////////////////////////////////////////////////////////
#ifndef _CDIALOGEX_
#define _CDIALOGEX_
/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#pragma warning (disable : 4251)
#pragma warning (disable : 4275)
/////////////////////////////////////////////////////////////////////////////
#include "AfxWin.h"
#include "FileUtil.h"
/////////////////////////////////////////////////////////////////////////////
#define kDlgLastKey		"l" 
#define kDlgStatusKey	"s"
#define kDlgWidthKey	"w"
#define kDlgHeightKey	"h"
#define kDlgXPosKey		"x" 
#define kDlgYPosKey		"y" 
#define kDlgHDockKey	"hd"
#define kDlgWDockKey	"wd"
/////////////////////////////////////////////////////////////////////////////
#define kDockU			-1
#define kDockWL			0
#define kDockWR			1
#define kDockWML		2
#define kDockWMR		3
#define kDockHT			4
#define kDockHB			5
#define kDockHMT		6
#define kDockHMB		7
#define kDockMaster		100

/////////////////////////////////////////////////////////////////////////////
class COMMON_API CDialogCfg
{
private:
	CString			mKey;
public:
	long			mWidth, mHeight, mXPos, mYPos;
	int				mStatus, mLast, mWDock, mHDock, mRestore;
public:
	CDialogCfg()				{ mWidth = mHeight = mXPos = mYPos =0; mStatus = mLast = mRestore = 0; mWDock = mHDock = 0;};
	CDialogCfg(CString iKey)	{ mWidth = mHeight = mXPos = mYPos =0; mStatus = mLast = 0; mWDock = mHDock = 0; mKey = iKey; };
	~CDialogCfg()				{};
	void			SetKey(CString iKey)	{ mKey = iKey; };
	BOOL			Save();
	BOOL			Load();
};
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CDialogEx : public CDialog
{
	DECLARE_DYNCREATE(CDialogEx)
private:
	BOOL					mDocked, mInited;
	HINSTANCE				mHInst;
	int						mDlgId;
	void					LoadPlacement();
	void					SavePlacement();
protected:
	CDialogCfg				mConfig;
// Implementation
public:
	CDialogEx(UInt16 iDlgID, HINSTANCE iHInst, CString iKey);
	virtual ~CDialogEx() {};
	BOOL					Init(CWnd *iParentP, BOOL iCheckConfig=FALSE);
	void					Close() { return OnDestroy(); };
	void					UpdatePosition(int iX, int iY);
// Overrides
protected:
	virtual void			DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	afx_msg void			OnClose();
	afx_msg void			OnDestroy();
	afx_msg void			OnShowWindow(BOOL iShow, UINT iStatus);
	afx_msg void			OnMove(int iDX, int iDY);
	// to prevent dialog closing on enter and esc key
	afx_msg void			OnOK();
	afx_msg void			OnCancel();
	
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

